class Inv expands Mutator;

//Translocator:
#exec TEXTURE IMPORT NAME=Trans0 FILE=Textures\UnrealTeamtloc1.pcx Group=Xloc MIPS=ON
#exec TEXTURE IMPORT NAME=Trans1 FILE=Textures\UnrealTeamtloc2.pcx Group=Xloc MIPS=ON
#exec TEXTURE IMPORT NAME=Trans2 FILE=Textures\UnrealTeamtloc3.pcx Group=Xloc MIPS=ON
#exec TEXTURE IMPORT NAME=Trans3 FILE=Textures\UnrealTeamtloc4.pcx Group=Xloc MIPS=ON
//Armor:
#exec TEXTURE IMPORT NAME=UTarmor FILE=Textures\UnrealTeamArmor.pcx Group=Inventory MIPS=ON
#exec AUDIO IMPORT FILE=Sounds\UTArmorSnd.WAV NAME="ArmorSound"
//Damage Amplifier:
#exec TEXTURE IMPORT NAME=UTamp FILE=Textures\UnrealTeamDamage.pcx Group=Inventory MIPS=ON
#exec AUDIO IMPORT FILE=Sounds\UTDamSnd.WAV NAME="AmpSound"
//Health Package:
#exec TEXTURE IMPORT NAME=UThp1 FILE=Textures\UnrealTeamHealthpack.pcx Group=Inventory MIPS=ON
#exec TEXTURE IMPORT NAME=UThp2 FILE=Textures\UnrealTeamHealthpackage.pcx Group=Inventory MIPS=ON
#exec AUDIO IMPORT FILE=Sounds\UTHealthSnd.WAV NAME="HealthPackageSound"
//Health Vial:
#exec TEXTURE IMPORT NAME=UTvial FILE=Textures\UnrealTeamHealthVial.pcx Group=Inventory MIPS=ON
#exec AUDIO IMPORT FILE=Sounds\UTVialSnd.WAV NAME="VialSound"
//Invisibility:
#exec TEXTURE IMPORT NAME=UTInv FILE=Textures\UnrealTeamInv.pcx Group=Inventory MIPS=ON
#exec AUDIO IMPORT FILE=Sounds\UTInvSnd.WAV NAME="InvSound"
//Jumpboots:
#exec TEXTURE IMPORT NAME=UTboots FILE=Textures\UnrealTeamJump.pcx Group=Inventory MIPS=ON
#exec AUDIO IMPORT FILE=Sounds\UTJumpSnd.WAV NAME="BootsSound"
//Medbox:
#exec TEXTURE IMPORT NAME=UTmedbox FILE=Textures\UnrealTeamMedBox.pcx Group=Inventory MIPS=ON
//Shieldbelt:
#exec TEXTURE IMPORT NAME=UTbelt FILE=Textures\UnrealTeamShieldBelt.pcx Group=Inventory MIPS=ON
#exec AUDIO IMPORT FILE=Sounds\UTShieldSnd.WAV NAME="BeltSound"
//ThighPads:
#exec TEXTURE IMPORT NAME=UTpads FILE=Textures\UnrealTeamThighPads.pcx Group=Inventory MIPS=ON

simulated function bool AlwaysKeep(Actor Other)
{
	if ( Other.IsA('Translocator'))
		{
		Translocator(Other).MultiSkins[0] = Texture'Trans0';
		Translocator(Other).MultiSkins[1] = Texture'Trans1';
		Translocator(Other).MultiSkins[2] = Texture'Trans2';
		Translocator(Other).MultiSkins[3] = Texture'Trans3';
		}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

simulated function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if ( Other.IsA('Armor2') && !Other.IsA('UTarmor') )
		{
		ReplaceWith(Other,"UnrealTeamInv.UTarmor");
		return false;
		}
	else if ( Other.IsA('UDamage') && !Other.IsA('UTamp') )
		{
		ReplaceWith(Other,"UnrealTeamInv.UTamp");
		return false;
		}
	else if ( Other.IsA('HealthPack') && !Other.IsA('UThp') )
		{
		ReplaceWith(Other,"UnrealTeamInv.UThp");
		return false;
		}
	else if ( Other.IsA('HealthVial') && !Other.IsA('UTvial') )
		{
		ReplaceWith(Other,"UnrealTeamInv.UTvial");
		return false;
		}
	else if ( Other.IsA('UT_Invisibility') && !Other.IsA('UTinv') )
		{
		ReplaceWith(Other,"UnrealTeamInv.UTinv");
		return false;
		}
	else if ( Other.IsA('UT_JumpBoots') && !Other.IsA('UTboots') )
		{
		ReplaceWith(Other,"UnrealTeamInv.UTboots");
		return false;
		}
	else if ( Other.IsA('MedBox') && !Other.IsA('UTmedbox') )
		{
		ReplaceWith(Other,"UnrealTeamInv.UTmedbox");
		return false;
		}
	else if ( Other.IsA('UT_ShieldBelt') && !Other.IsA('UTbelt') )
		{
		ReplaceWith(Other,"UnrealTeamInv.UTbelt");
		return false;
		}
	else if ( Other.IsA('ThighPads') && !Other.IsA('UTpads') )
		{
		ReplaceWith(Other,"UnrealTeamInv.UTpads");
		return false;
		}
return true;
}

defaultproperties
{
}


